import { StaticKey } from '@/types'
import axios, { AxiosRequestConfig } from 'axios'
import { getCookie } from 'cookies-next/client'

interface CustomAxiosRequestConfig<TData> extends AxiosRequestConfig<TData> {
  withToken?: boolean
  lang?: string
}

const client = axios.create()

export const request = async <TResponse = any, TData = any>({
  withToken = true,
  lang,
  ...options
}: CustomAxiosRequestConfig<TData>): Promise<TResponse> => {
  const apiUrl = process.env.NEXT_PUBLIC_API_URL

  if (apiUrl) {
    client.defaults.baseURL = apiUrl
  }

  const language = getCookie('NEXT_LOCALE') || lang || 'en'

  client.defaults.headers.common['accept-language'] = language

  if (withToken) {
    const token = getCookie(StaticKey.ACCESS_TOKEN) || null

    if (token) {
      client.defaults.headers.common.Authorization = `Bearer ${token}`
    }
  }

  return client({ ...options }).then(data => data.data)
}
