export type TPageSizeOption = 5 | 10 | 20 | number

export type TPaginationModel = {
    with_paginate?: 'yes' | 'no'
    page?: number
    per_page?: TPageSizeOption
}

export type TSearch = {
    with_search?: boolean
    search_txt?: string
}

interface IPaginateLink {
    url: string | null
    label: string
    active: boolean
}

export interface IPaginatedData<TData = any> {
    current_page: number
    data: TData
    first_page_url: string
    from: number
    last_page: number
    last_page_url: string
    links: IPaginateLink[]
    next_page_url: string | null
    path: string
    per_page: number
    prev_page_url: string | null
    to: number
    total: number
}
