import {
  QueryKey,
  RefetchOptions,
  RefetchQueryFilters,
  UseMutationOptions,
} from "@tanstack/react-query";

export interface CustomUseMutationOptions<
  TData = any,
  TError = any,
  TVariable = any,
  TContext = unknown
> extends Omit<
    UseMutationOptions<TData, TError, TVariable, TContext>,
    "mutationKey" | "mutationFn"
  > {
  invalidateQueries?: QueryKey;
  refetchQueries?: {
    filters?: RefetchQueryFilters;
    options?: RefetchOptions;
  }[];
  withoutToastMessage?: boolean;
  toastMessageType?: "promise" | "default";
  promise?: {
    message?: {
      onLoading?: string;
      onSuccess?: string;
      onError?: string;
    };
    withoutTranslation?: boolean;
  };
}
