import { useCustomQuery } from '@/components/hooks/api'
import { request } from '@/utils/request'
import type { IBaseResponse, IUser } from '@/types'

export const USER_PROFILE_DATA_QUERY_KEY = 'user-profile-data'

export const useGetUserProfile = (isEnabled?: boolean) => {
  const queryKey: [string] = [USER_PROFILE_DATA_QUERY_KEY]

  return useCustomQuery<IBaseResponse<IUser>>(
    queryKey,
    () =>
      request({
        url: 'auth/profile'
      }),
    { enabled: isEnabled ?? true }
  )
}
