import { CustomUseQueryOptions } from "@/types";
import { QueryFunction, QueryKey, useQuery } from "@tanstack/react-query";
import { AxiosError } from "axios";
import { useEffect } from "react";

export const useCustomQuery = <
  TQueryFnData = any,
  TQueryKey extends QueryKey = QueryKey,
  TData = TQueryFnData
>(
  queryKey: TQueryKey,
  queryFn: QueryFunction<TQueryFnData, TQueryKey>,
  options?: CustomUseQueryOptions<
    TQueryFnData,
    TQueryKey,
    TData,
    AxiosError<any, any>
  >
) => {
  const query = useQuery<TQueryFnData, AxiosError<any>, TData, TQueryKey>({
    queryKey,
    queryFn,
    refetchInterval: false,
    refetchOnMount: "always",
    refetchOnReconnect: "always",
    refetchOnWindowFocus: false,
    staleTime: 1000 * 60 * 1,
    ...options,
  });

  useEffect(() => {
    if (query.isError) {
      const status = query?.error?.response?.status;
      if (status === 401) {
      }
    } else if (query.isSuccess) {
    }
  }, [query.isPending]);

  return query;
};
