'use client'

import type { ReactNode } from 'react'
import { Dialog, DialogActions, DialogContent, DialogTitle } from '@mui/material'

import Button from '@/@core/components/mui/Button'
import Translation from '@/@core/components/translation'
import DialogCloseButton from './DialogCloseButton'

type ViewDialogProps = {
  open: boolean
  setOpen: (open: boolean) => void
  content: ReactNode
  title?: ReactNode
  cancelLabel?: string
}

const ViewDialog = ({ open, setOpen, content, title, cancelLabel }: ViewDialogProps) => {
  const resolvedCancelLabel = cancelLabel ?? 'KEY.CANCEL'
  const resolvedTitle = typeof title === 'string' ? <Translation text={title} /> : title

  return (
    <Dialog
      fullWidth
      open={open}
      onClose={() => setOpen(false)}
      maxWidth='sm'
      scroll='body'
      closeAfterTransition={false}
      sx={{ '& .MuiDialog-paper': { overflow: 'visible' } }}
      aria-labelledby='view-dialog-title'
    >
      <DialogCloseButton onClick={() => setOpen(false)} disableRipple>
        <i className='tabler-x' />
      </DialogCloseButton>
      {resolvedTitle && (
        <DialogTitle id='view-dialog-title' variant='h4' className='text-center sm:pbs-10 sm:pbe-2 sm:pli-10'>
          {resolvedTitle}
        </DialogTitle>
      )}
      <DialogContent className='flex gap-2 flex-col text-center sm:pbs-10 sm:pbe-8 sm:pli-10'>{content}</DialogContent>
      <DialogActions className='justify-center pbs-0 sm:pbe-10 sm:pli-10'>
        <Button variant='outlined' color='error' onClick={() => setOpen(false)} type='button'>
          {resolvedCancelLabel}
        </Button>
      </DialogActions>
    </Dialog>
  )
}

export default ViewDialog
