'use client'

import { Dialog, DialogActions, DialogTitle } from '@mui/material'
import DialogCloseButton from './DialogCloseButton'
import Button from '@/@core/components/mui/Button'
import Translation from '@/@core/components/translation'
import type { TranslationOptions } from '@/@core/types/translation.interface'

type DeleteDialogProps = {
  open: boolean
  setOpen: (open: boolean) => void
  onClick: () => void
  isPending?: boolean
  title?: string
  deleteLabel?: string
  cancelLabel?: string
  translationOptions?: TranslationOptions
}

const DeleteDialog = ({
  open,
  setOpen,
  onClick,
  isPending,
  title,
  deleteLabel,
  cancelLabel,
  translationOptions
}: DeleteDialogProps) => {
  const resolvedTitle = title ?? 'DIALOG.DELETE_TITLE'
  const resolvedDeleteLabel = deleteLabel ?? 'PROPERTY.DELETE'
  const resolvedCancelLabel = cancelLabel ?? 'KEY.CANCEL'

  return (
    <Dialog
      fullWidth
      open={open}
      onClose={() => setOpen(false)}
      maxWidth='sm'
      scroll='body'
      closeAfterTransition={false}
      sx={{ '& .MuiDialog-paper': { overflow: 'visible' } }}
      aria-labelledby='delete-dialog-title'
    >
      <DialogCloseButton onClick={() => setOpen(false)} disableRipple>
        <i className='tabler-x' />
      </DialogCloseButton>
      <DialogTitle
        id='delete-dialog-title'
        variant='h4'
        className='flex gap-2 flex-col text-center sm:pbs-10 sm:pbe-8 sm:pli-10'
      >
        <Translation text={resolvedTitle} {...translationOptions} />
      </DialogTitle>
      <DialogActions className='justify-center pbs-0 sm:pbe-10 sm:pli-10'>
        <Button
          variant='contained'
          color='error'
          onClick={onClick}
          type='submit'
          isLoading={isPending}
          disabled={isPending}
        >
          <Translation text={resolvedDeleteLabel} {...translationOptions} />
        </Button>
        <Button variant='outlined' color='primary' onClick={() => setOpen(false)} type='button' disabled={isPending}>
          <Translation text={resolvedCancelLabel} {...translationOptions} />
        </Button>
      </DialogActions>
    </Dialog>
  )
}

export default DeleteDialog
