// Type Imports
import type { ChildrenType, Direction } from '@core/types'

// Context Imports
import { NextAuthProvider } from '@/contexts/nextAuthProvider'
import { VerticalNavProvider } from '@menu/contexts/verticalNavContext'
import { SettingsProvider } from '@core/contexts/settingsContext'
import ThemeProvider from '@components/theme'
import AuthSessionSync from '@components/AuthSessionSync'
import ReactQueryProvider from '@components/ReactQueryProvider'
import LanguageCookieSync from '@components/LanguageCookieSync'

// Util Imports
import { getMode, getSettingsFromCookie, getSystemMode } from '@core/utils/serverHelpers'

type Props = ChildrenType & {
  direction: Direction
}

const Providers = async (props: Props) => {
  // Props
  const { children, direction } = props

  // Vars
  const mode = await getMode()
  const settingsCookie = await getSettingsFromCookie()
  const systemMode = await getSystemMode()

  const authBasePath = process.env.NEXTAUTH_BASEPATH
  const sessionBasePath = authBasePath && authBasePath.startsWith('/') ? authBasePath : undefined

  return (
    <NextAuthProvider basePath={sessionBasePath}>
      <AuthSessionSync />
      <LanguageCookieSync />
      <ReactQueryProvider>
        <VerticalNavProvider>
          <SettingsProvider settingsCookie={settingsCookie} mode={mode}>
            <ThemeProvider direction={direction} systemMode={systemMode}>
              {children}
            </ThemeProvider>
          </SettingsProvider>
        </VerticalNavProvider>
      </ReactQueryProvider>
    </NextAuthProvider>
  )
}

export default Providers
