'use client'

import { useEffect } from 'react'

import { useParams } from 'next/navigation'
import { setCookie } from 'cookies-next/client'

import type { Locale } from '@/configs/i18n'

const LanguageCookieSync = () => {
  const { lang } = useParams()

  useEffect(() => {
    if (typeof lang !== 'string') {
      return
    }

    setCookie('NEXT_LOCALE', lang as Locale, { sameSite: 'lax' })
  }, [lang])

  return null
}

export default LanguageCookieSync
