'use client'

import { useEffect } from 'react'

import { useSession } from 'next-auth/react'
import { deleteCookie, setCookie } from 'cookies-next/client'

import { StaticKey } from '@/types'

const AuthSessionSync = () => {
  const { data: session, status } = useSession()

  useEffect(() => {
    if (status === 'loading') {
      return
    }

    if (session?.accessToken) {
      const expiresAt = session.expires ? new Date(session.expires).getTime() : null
      const maxAge =
        expiresAt && expiresAt > Date.now() ? Math.floor((expiresAt - Date.now()) / 1000) : undefined

      setCookie(StaticKey.ACCESS_TOKEN, session.accessToken, { sameSite: 'lax', maxAge })
      setCookie(StaticKey.USER, JSON.stringify(session.user), { sameSite: 'lax', maxAge })

      if (session.user?.id) {
        setCookie(StaticKey.USER_ID, session.user.id, { sameSite: 'lax', maxAge })
      }

      return
    }

    deleteCookie(StaticKey.ACCESS_TOKEN)
    deleteCookie(StaticKey.USER_ID)
    deleteCookie(StaticKey.USER)
  }, [session, status])

  return null
}

export default AuthSessionSync
