'use client'

import { useEffect } from 'react'

import { signOut, useSession } from 'next-auth/react'
import { useParams, useRouter } from 'next/navigation'

import type { Locale } from '@/configs/i18n'
import { useGetUserProfile } from '@/hooks/api'
import { getLocalizedUrl } from '@/utils/i18n'

const AuthProfileGate = () => {
  const router = useRouter()
  const { lang: locale } = useParams()
  const { status } = useSession()

  const isEnabled = status === 'authenticated'
  const profileQuery = useGetUserProfile(isEnabled)

  useEffect(() => {
    if (!isEnabled || !profileQuery.isError) {
      return
    }

    const statusCode = profileQuery.error?.response?.status

    if (statusCode === 401 || statusCode === 403) {
      signOut({ redirect: false }).finally(() => {
        router.replace(getLocalizedUrl('/login', locale as Locale))
      })
    }
  }, [isEnabled, profileQuery.isError, profileQuery.error, router, locale])

  return null
}

export default AuthProfileGate
