'use client'

import type { ElementType } from 'react'
import BaseButton, { type ButtonProps as BaseButtonProps } from '@mui/material/Button'
import { CircularProgress } from '@mui/material'

import type { IBaseProps } from '@/@core/types/base-props.interface'
export type ButtonProps<Component extends ElementType = 'button'> = BaseButtonProps<
  Component,
  IBaseProps<Component> & { isLoading?: boolean }
>

const Button = <Component extends ElementType = 'button'>(props: ButtonProps<Component>) => {
  const { isLoading = false, withoutTranslation = false, options, ...rest } = props
  const shouldTranslate = !withoutTranslation && typeof props.children === 'string'

  return (
    <BaseButton fullWidth {...rest}>
      {isLoading ? (
        <>
          <CircularProgress size={18} color='inherit' className='me-1' />
          {props.children}
        </>
      ) : (
        props.children
      )}
    </BaseButton>
  )
}

export default Button
