import type { NextConfig } from 'next'

const basePath = process.env.BASEPATH

const nextConfig: NextConfig = {
  basePath: basePath,
  // redirects: async () => {
  //   return [
  //     {
  //       source: '/',
  //       destination: '/home',
  //       permanent: true,
  //       locale: false
  //     }
  //   ]
  // }
  redirects: async () => {
    return [
      {
        source: '/',
        destination: '/en',
        permanent: true,
        locale: false
      },
      {
        source: '/:lang(en|ar)',
        destination: '/:lang/home',
        permanent: true,
        locale: false
      },
      {
        source: '/:path((?!en|ar|images|api|favicon.ico).*)*',
        destination: '/en/:path*',
        permanent: true,
        locale: false
      }
    ]
  }
}

export default nextConfig
